/*
 * Decompiled with CFR 0.152.
 */
package me.theminddroid.drugs;

import java.util.Objects;
import me.theminddroid.drugs.DrugCommandExecutor;
import me.theminddroid.drugs.DrugTabCompleter;
import me.theminddroid.drugs.Metrics;
import me.theminddroid.drugs.listeners.NarcanListener;
import me.theminddroid.drugs.listeners.PsychoactiveDrugListener;
import me.theminddroid.drugs.models.Drug;
import me.theminddroid.drugs.models.Recipes;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class DrugsPlugin
extends JavaPlugin {
    public void onEnable() {
        Bukkit.getLogger().info("[Drugs] Drugs by TheMindDroid.");
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        FileConfiguration messageConfig = ((DrugsPlugin)DrugsPlugin.getPlugin(DrugsPlugin.class)).getConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new PsychoactiveDrugListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NarcanListener(), (Plugin)this);
        Objects.requireNonNull(this.getCommand("drugs")).setExecutor((CommandExecutor)new DrugCommandExecutor());
        Objects.requireNonNull(this.getCommand("drugs")).setTabCompleter((TabCompleter)new DrugTabCompleter());
        new Metrics((Plugin)this, 10825);
        if (!messageConfig.getBoolean("allRecipes.enabled")) {
            Bukkit.getLogger().info("[Drugs] Drug recipes have been disabled. Visit config file to change.");
            return;
        }
        Bukkit.getLogger().info("[Drugs] Building drug recipes:");
        for (Drug recipe : Drug.values()) {
            if (!messageConfig.getBoolean(recipe.getDrugName() + "Recipe.enabled")) continue;
            Bukkit.getLogger().info("[Drugs] Generating recipe for " + recipe.getDrugName() + "...");
            Recipe drugRecipe = Recipes.getDrugRecipe((Plugin)this, recipe);
            if (drugRecipe == null) continue;
            this.getServer().addRecipe(drugRecipe);
        }
    }

    public static DrugsPlugin getInstance() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("Drugs");
        if (!(plugin instanceof DrugsPlugin)) {
            throw new RuntimeException("'Drugs' not found. 'Drugs' plugin disabled?");
        }
        return (DrugsPlugin)plugin;
    }

    public void onDisable() {
        for (Drug recipe : Drug.values()) {
            Bukkit.getLogger().info("[Drugs] Unregistering recipe for " + recipe.getDrugName() + "...");
            this.getServer().removeRecipe(Recipes.getKey((Plugin)this, recipe));
        }
        Bukkit.getLogger().info("Drugs plugin has terminated.");
    }
}

